from Tkinter import *
import time,sys,thread


class VisualInterface:
    def __init__(self, parent, child):
        ##  TKR is required to be placed HERE  ##
        self.tkr = parent
        self.visuals = child
        
        ##  Variable declaration  ##
        self.tvSphereTracers = BooleanVar()
        self.tvSphereVectors = BooleanVar()
        self.tvSpherePoints = BooleanVar()
        self.tvSphereTorqueVectors = BooleanVar()
        self.tvSphereAxis = BooleanVar()
        self.tvSphereAxisSync = BooleanVar()
        
        self.tvLatticeTracers = BooleanVar()
        self.tvLatticeVectors = BooleanVar()
        self.tvLatticePoints = BooleanVar()
        self.tvLatticeTorqueVectors = BooleanVar()
        self.tvLatticeBonds = BooleanVar()
        ##  Variable declaration  ##


        ##  TKR appearance and widget creation  ##
        self.tkr.wm_geometry(newGeometry="260x180+1000+480")   
        self.tkr.wm_title("Visual Controls")
        #
        self.tkr.topFrame = Frame(self.tkr, relief=SUNKEN, borderwidth=0)
        self.tkr.topFrame.grid(row=0, column=0, padx=0, pady=0)
        #
        self.tkr.toggleFrame = Frame(self.tkr.topFrame, relief=FLAT, borderwidth=0)
        self.tkr.toggleFrame.grid(row=0, column=0, padx=4, pady=4)

        ###########################################################################
        self.tkr.sphereFrame = Frame(self.tkr.toggleFrame, relief=FLAT, borderwidth=0)
        self.tkr.sphereFrame.grid(row=0, column=0, padx=0, pady=0)
        #
        self.tkr.sphereOptionsLabel = Label(self.tkr.sphereFrame, text="Sphere:").grid(row=0, column=0, sticky=E)
        #
        self.tkr.sphereTracersLabel = Label(self.tkr.sphereFrame, text="Tracers").grid(row=1, column=0, sticky=E)
        self.tkr.sphereTracersWidget = Checkbutton(self.tkr.sphereFrame, text="", variable=self.tvSphereTracers, command=self.toggleSphereTracers)
        self.tkr.sphereTracersWidget.grid(row=1, column=1)
        self.tkr.sphereTracersWidget.toggle()
        self.tkr.sphereVectorsLabel = Label(self.tkr.sphereFrame, text="Vectors").grid(row=2, column=0, sticky=E)
        self.tkr.sphereVectorsWidget = Checkbutton(self.tkr.sphereFrame, text="", variable=self.tvSphereVectors, command=self.toggleSphereVectors)
        self.tkr.sphereVectorsWidget.grid(row=2, column=1)
##        self.tkr.sphereVectorsWidget.toggle()
        self.tkr.spherePointsLabel = Label(self.tkr.sphereFrame, text="Points").grid(row=3, column=0, sticky=E)
        self.tkr.spherePointsWidget = Checkbutton(self.tkr.sphereFrame, text="", variable=self.tvSpherePoints, command=self.toggleSpherePoints)
        self.tkr.spherePointsWidget.grid(row=3, column=1)

        
        self.tkr.sphereTorqueVectorsLabel = Label(self.tkr.sphereFrame, text="Torques").grid(row=4, column=0, sticky=E)
        self.tkr.sphereTorqueVectorsWidget = Checkbutton(self.tkr.sphereFrame, text="", variable=self.tvSphereTorqueVectors, command=self.toggleSphereTorqueVectors)
        self.tkr.sphereTorqueVectorsWidget.grid(row=4, column=1)
##        self.tkr.sphereTorqueVectorsWidget.toggle()


        
        self.tkr.displayAxisLabel = Label(self.tkr.sphereFrame, text="Display Axis").grid(row=5, column=0, sticky=E)
        self.tkr.displayAxisWidget = Checkbutton(self.tkr.sphereFrame, text="", variable=self.tvSphereAxis, command=self.toggleSphereAxis)
        self.tkr.displayAxisWidget.grid(row=5, column=1)
##        self.tkr.displayAxisWidget.toggle()
        self.tkr.followAxisLabel = Label(self.tkr.sphereFrame, text="Follow Axis").grid(row=6, column=0, sticky=E)
        self.tkr.followAxisWidget = Checkbutton(self.tkr.sphereFrame, text="", variable=self.tvSphereAxisSync, command=self.toggleSphereAxisSync)
        self.tkr.followAxisWidget.grid(row=6, column=1)
        ###########################################################################

        ###########################################################################
        self.tkr.latticeFrame = Frame(self.tkr.toggleFrame, relief=FLAT, borderwidth=0)
        self.tkr.latticeFrame.grid(row=0, column=1, padx=6, pady=0)
        #
        self.tkr.latticeOptionsLabel = Label(self.tkr.latticeFrame, text="Lattice:").grid(row=0, column=0, sticky=E)
        #
        self.tkr.latticeTracersLabel = Label(self.tkr.latticeFrame, text="Tracers").grid(row=1, column=0, sticky=E)
        self.tkr.latticeTracersWidget = Checkbutton(self.tkr.latticeFrame, text="", variable=self.tvLatticeTracers, command=self.toggleLatticeTracers)
        self.tkr.latticeTracersWidget.grid(row=1, column=1)
        self.tkr.latticeTracersWidget.toggle()
        self.tkr.latticeVectorsLabel = Label(self.tkr.latticeFrame, text="Vectors").grid(row=2, column=0, sticky=E)
        self.tkr.latticeVectorsWidget = Checkbutton(self.tkr.latticeFrame, text="", variable=self.tvLatticeVectors, command=self.toggleLatticeVectors)
        self.tkr.latticeVectorsWidget.grid(row=2, column=1)
##        self.tkr.latticeVectorsWidget.toggle()
        self.tkr.latticePointsLabel = Label(self.tkr.latticeFrame, text="Points").grid(row=3, column=0, sticky=E)
        self.tkr.latticePointsWidget = Checkbutton(self.tkr.latticeFrame, text="", variable=self.tvLatticePoints, command=self.toggleLatticePoints)
        self.tkr.latticePointsWidget.grid(row=3, column=1)

        
        self.tkr.latticeTorqueVectorsLabel = Label(self.tkr.latticeFrame, text="Torques").grid(row=4, column=0, sticky=E)
        self.tkr.latticeTorqueVectorsWidget = Checkbutton(self.tkr.latticeFrame, text="", variable=self.tvLatticeTorqueVectors, command=self.toggleLatticeTorqueVectors)
        self.tkr.latticeTorqueVectorsWidget.grid(row=4, column=1)
##        self.tkr.latticeTorqueVectorsWidget.toggle()

        
        self.tkr.latticeBondsLabel = Label(self.tkr.latticeFrame, text="Bonds").grid(row=5, column=0, sticky=E)
        self.tkr.latticeBondsWidget = Checkbutton(self.tkr.latticeFrame, text="", variable=self.tvLatticeBonds, command=self.toggleLatticeBonds)
        self.tkr.latticeBondsWidget.grid(row=5, column=1)
##        self.tkr.latticeBondsWidget.toggle()
        
        self.tkr.space = Label(self.tkr.latticeFrame, text="   ").grid(row=6, column=0, sticky=E)
        self.tkr.resetWidget = Button(self.tkr.latticeFrame, text="Reset", command=self.visuals.reset).grid(row=6, column=1, columnspan=2, padx=0, pady=0, sticky=S) 
        ###########################################################################
        ##  TKR appearance and widget creation  ##


   
    def toggleSphereTracers(self):
        self.visuals.vSphere.toggleTracers()

    def toggleSphereVectors(self):
        self.visuals.vSphere.toggleVectors()

    def toggleSpherePoints(self):
        self.visuals.vSphere.togglePoints()

    def toggleSphereTorqueVectors(self):
        self.visuals.vSphere.toggleTorqueVectors()

    def toggleSphereAxis(self):
        self.visuals.vSphere.toggleAxis()

    def toggleSphereAxisSync(self):
        pass
        
    def toggleLatticeTracers(self):
        self.visuals.vLattice.toggleTracers()

    def toggleLatticeVectors(self):
        self.visuals.vLattice.toggleVectors()

    def toggleLatticePoints(self):
        self.visuals.vLattice.togglePoints()

    def toggleLatticeTorqueVectors(self):
        self.visuals.vLattice.toggleTorqueVectors()

    def toggleLatticeBonds(self):
        self.visuals.vLattice.toggleBonds()

     

##    def setTracerLength(self, tracerLength):
##        self.hold()
##        self.tracerLength = float(tracerLength)
##        self.unhold()


